/*
 * Decompiled with CFR 0.152.
 */
package journeymap.api.common;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import journeymap.api.v2.client.display.DisplayType;
import journeymap.api.v2.client.display.Displayable;
import journeymap.api.v2.client.display.ImageOverlay;
import journeymap.api.v2.client.display.MarkerOverlay;
import journeymap.api.v2.client.display.Overlay;
import journeymap.api.v2.client.display.PolygonOverlay;
import journeymap.api.v2.client.model.ShapeProperties;
import journeymap.api.v2.client.util.UIState;
import journeymap.api.v2.common.IJourneyMapPlugin;
import journeymap.api.v2.common.waypoint.Waypoint;
import journeymap.client.data.DataCache;
import journeymap.client.render.draw.DrawImageStep;
import journeymap.client.render.draw.DrawMarkerStep;
import journeymap.client.render.draw.DrawPolygonStep;
import journeymap.client.render.draw.OverlayDrawStep;
import journeymap.client.texture.ImageUtil;
import journeymap.client.texture.TextureAccess;
import journeymap.client.texture.TextureCache;
import journeymap.client.waypoint.ClientWaypointImpl;
import journeymap.common.CommonConstants;
import journeymap.common.Journeymap;
import journeymap.common.accessors.TextureManagerAccess;
import journeymap.common.helper.DimensionHelper;
import journeymap.common.log.LogFormatter;
import journeymap.common.waypoint.WaypointIcon;
import journeymap.common.waypoint.WaypointImpl;
import journeymap.common.waypoint.WaypointStore;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1060;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5321;

@ParametersAreNonnullByDefault
public class PluginWrapper {
    private final IJourneyMapPlugin plugin;
    private final String modId;
    private final HashMap<String, HashBasedTable<String, Overlay, OverlayDrawStep>> dimensionOverlays = new HashMap();

    public PluginWrapper(IJourneyMapPlugin plugin) {
        this.modId = plugin.getModId();
        this.plugin = plugin;
    }

    public HashBasedTable<String, Overlay, OverlayDrawStep> getOverlays(class_5321<class_1937> dimension) {
        String dimName = DimensionHelper.getDimKeyName(dimension);
        HashBasedTable table = this.dimensionOverlays.get(dimName);
        if (table == null) {
            table = HashBasedTable.create();
            this.dimensionOverlays.put(dimName, (HashBasedTable<String, Overlay, OverlayDrawStep>)table);
        }
        return table;
    }

    public void show(Displayable displayable) throws Exception {
        String displayId = displayable.getId();
        switch (displayable.getDisplayType()) {
            case Polygon: {
                PolygonOverlay polygon = (PolygonOverlay)displayable;
                DrawPolygonStep polygonStep = DataCache.INSTANCE.getDrawPolygonStep(polygon);
                ShapeProperties prop = polygon.getShapeProperties();
                if (prop.getImage() != null || prop.getImageLocation() != null) {
                    polygonStep.setTextureResource(this.getPolygonImageResource(polygon));
                }
                polygonStep.setEnabled(true);
                this.getOverlays((class_5321<class_1937>)polygon.getDimension()).put((Object)displayId, (Object)polygon, (Object)polygonStep);
                break;
            }
            case Marker: {
                MarkerOverlay marker = (MarkerOverlay)displayable;
                DrawMarkerStep markerStep = DataCache.INSTANCE.getDrawMakerStep(marker);
                markerStep.setEnabled(true);
                this.getOverlays((class_5321<class_1937>)marker.getDimension()).put((Object)displayId, (Object)marker, (Object)markerStep);
                break;
            }
            case Image: {
                ImageOverlay imageOverlay = (ImageOverlay)displayable;
                DrawImageStep imageStep = DataCache.INSTANCE.getDrawImageStep(imageOverlay);
                imageStep.setEnabled(true);
                this.getOverlays((class_5321<class_1937>)imageOverlay.getDimension()).put((Object)displayId, (Object)imageOverlay, (Object)imageStep);
                break;
            }
        }
    }

    @Nullable
    public Waypoint getWaypoint(String guid) {
        ClientWaypointImpl waypoint = WaypointStore.getInstance().get(guid);
        if (waypoint != null && this.modId.equals(waypoint.getModId())) {
            return waypoint;
        }
        return null;
    }

    public List<Waypoint> getWaypoints() {
        return WaypointStore.getInstance().getAll().stream().filter(waypoint -> this.modId.equals(waypoint.getModId())).collect(Collectors.toList());
    }

    private class_2960 convertToFakeIcon(Waypoint waypoint) {
        class_2960 fakeLocation;
        class_1060 manager;
        WaypointIcon image = ((WaypointImpl)waypoint).getIcon();
        class_2960 identifier = image.getIdentifier();
        if (identifier != null && ((TextureManagerAccess)(manager = class_310.method_1551().method_1531())).journeymap$getTex(fakeLocation = class_2960.method_60655((String)"fake", (String)identifier.method_12832())) == null) {
            try (class_1011 nativeImage = TextureCache.resolveImage(identifier);){
                class_1011 img = ImageUtil.getScaledImage(4.0f, nativeImage, false);
                class_1043 scaledTexture = new class_1043(null, img);
                manager.method_4616(fakeLocation, (class_1044)scaledTexture);
                ((TextureAccess)scaledTexture).journeymap$setDisplayHeight(image.getTextureHeight());
                ((TextureAccess)scaledTexture).journeymap$setDisplayWidth(image.getTextureWidth());
                TextureCache.modTextureMap.put(identifier, fakeLocation);
            }
        }
        return identifier;
    }

    private class_2960 getPolygonImageResource(PolygonOverlay polygon) {
        class_2960 oldLocation;
        class_1060 manager;
        ShapeProperties prop = polygon.getShapeProperties();
        class_1011 image = prop.getImage();
        class_2960 identifier = prop.getImageLocation();
        if (image != null) {
            identifier = class_2960.method_60655((String)"fake", (String)CommonConstants.getSafeString(polygon.getGuid(), "-").toLowerCase(Locale.ROOT));
            class_1011 clonedImage = new class_1011(image.method_4307(), image.method_4323(), false);
            clonedImage.method_4317(image);
            class_1043 texture = new class_1043(null, clonedImage);
            class_310.method_1551().method_1531().method_4616(identifier, (class_1044)texture);
        } else if (identifier != null && ((TextureManagerAccess)(manager = class_310.method_1551().method_1531())).journeymap$getTex(identifier = class_2960.method_60655((String)"fake", (String)(oldLocation = identifier).method_12832())) == null) {
            try (class_1011 nativeImage = TextureCache.resolveImage(oldLocation);){
                class_1011 clonedImage = new class_1011(nativeImage.method_4307(), nativeImage.method_4323(), false);
                clonedImage.method_4317(nativeImage);
                class_1043 dynamicTexture = new class_1043(null, clonedImage);
                manager.method_4616(identifier, (class_1044)dynamicTexture);
            }
        }
        return identifier;
    }

    public void remove(Displayable displayable) {
        String displayId = displayable.getId();
        try {
            Overlay overlay = (Overlay)displayable;
            OverlayDrawStep drawStep = (OverlayDrawStep)this.getOverlays((class_5321<class_1937>)overlay.getDimension()).remove((Object)displayId, (Object)displayable);
            if (drawStep != null) {
                drawStep.setEnabled(false);
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("Error removing DrawMarkerStep: {}", (Object)LogFormatter.toString(t), (Object)t);
        }
    }

    public void remove(Waypoint wp) {
        ClientWaypointImpl waypoint = WaypointStore.getInstance().get(wp.getGuid());
        if (waypoint != null && wp.getModId().equals(waypoint.getModId())) {
            WaypointStore.getInstance().remove(waypoint, true);
        }
    }

    public void add(Waypoint waypoint) {
        if (((WaypointImpl)waypoint).getIcon() != null && !"journeymap".equals(((WaypointImpl)waypoint).getIcon().getIdentifier().method_12836())) {
            WaypointIcon icon = new WaypointIcon(this.convertToFakeIcon(waypoint));
            icon.setColor(((WaypointImpl)waypoint).getIcon().getColor());
            ((WaypointImpl)waypoint).setIcon(icon);
        }
        ((WaypointImpl)waypoint).setDirty(true);
        WaypointStore.getInstance().save((ClientWaypointImpl)waypoint, true);
    }

    public void removeAll(DisplayType displayType) {
        for (HashBasedTable<String, Overlay, OverlayDrawStep> overlays : this.dimensionOverlays.values()) {
            ArrayList list = new ArrayList(overlays.columnKeySet());
            for (Displayable displayable : list) {
                if (displayable.getDisplayType() != displayType) continue;
                this.remove(displayable);
                if (!(displayable instanceof PolygonOverlay)) continue;
                PolygonOverlay polygonOverlay = (PolygonOverlay)displayable;
                DataCache.INSTANCE.invalidatePolygon(polygonOverlay);
            }
        }
    }

    public void removeAllWaypoints() {
        List<ClientWaypointImpl> waypoints = WaypointStore.getInstance().getAll(this.modId);
        for (Waypoint waypoint : waypoints) {
            this.remove(waypoint);
        }
        if (!this.dimensionOverlays.isEmpty()) {
            this.dimensionOverlays.clear();
        }
    }

    public boolean exists(Displayable displayable) {
        String displayId = displayable.getId();
        if (displayable instanceof Overlay) {
            class_5321 dimension = ((Overlay)displayable).getDimension();
            return this.getOverlays((class_5321<class_1937>)dimension).containsRow((Object)displayId);
        }
        return false;
    }

    public void getDrawSteps(List<OverlayDrawStep> list, UIState uiState) {
        HashBasedTable<String, Overlay, OverlayDrawStep> table = this.getOverlays((class_5321<class_1937>)uiState.dimension);
        for (Table.Cell cell : table.cellSet()) {
            if (!((Overlay)cell.getColumnKey()).isActiveIn(uiState)) continue;
            list.add((OverlayDrawStep)cell.getValue());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PluginWrapper)) {
            return false;
        }
        PluginWrapper that = (PluginWrapper)o;
        return Objects.equal((Object)this.modId, (Object)that.modId);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.modId});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this.plugin).add("modId", (Object)this.modId).toString();
    }
}

